<?php



/*
---- DeepHost : MySQL Database PHP Server ---
---- Last Update : 18-06-2024 10:27AM ----
*/

function createTableFromJSON($json, $charset) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];

    $tableName = replace_item($tableName);

    unset($tableInfo['tableName']);

     $query = "CREATE TABLE IF NOT EXISTS $tableName (";
    foreach ($tableInfo as $column => $type) {
        $query .= replace_item($column)." $type, ";
    }
    $query = rtrim($query, ", ");
  
    $query .= ") DEFAULT CHARSET=$charset";

    return $query.";";
}

function addColumnFromJSON($json){

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) || !isset($tableInfo['columnType'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];
    $columnType =  $tableInfo['columnType'];

    $tableName = replace_item($tableName);


     $query = "ALTER TABLE $tableName ADD $columnName $columnType";

    return $query.";";
}

function removeColumnFromJSON($json){

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];

    $tableName = replace_item($tableName);

    $query = "ALTER TABLE $tableName DROP COLUMN $columnName";

    return $query.";";
}


function deleteRowFromJSON($json) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) || !isset($tableInfo['columnValue'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];
    $columnValue = $tableInfo['columnValue'];

    if ($tableName != null && $columnName != null && $columnValue != null) {

        $tableName = replace_item($tableName);

        $query = "DELETE FROM $tableName WHERE $columnName = '$columnValue'";
   
       return $query;
   }else{
       return "error";
   }

}

function getRowFromJSON($json) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) || !isset($tableInfo['columnValue'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];
    $columnValue = $tableInfo['columnValue'];

    if ($tableName != null && $columnName != null && $columnValue != null) {

        $tableName = replace_item($tableName);

        $query = "SELECT * FROM $tableName WHERE $columnName = '$columnValue'";

       return $query;
   }else{
       return "error";
   }
}


function getAddValueCountJSON($json) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) || !isset($tableInfo['valueCount']) || !isset($tableInfo['conditions'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];
    $valueCount = $tableInfo['valueCount'];

    $conditions = isset($tableInfo['conditions']) ? $tableInfo['conditions'] : null;

    if ($tableName != null && $columnName != null && $valueCount != null) {

        $tableName = replace_item($tableName);

    
        $query = "UPDATE $tableName  SET $columnName = $columnName + $valueCount";
    
        if ($conditions !== null) {

            $whereParts = [];

            foreach ($conditions as $condition) {

                if (isset($condition['type'])){
                    if ($condition['type'] === 'AND' || $condition['type'] === 'OR' || $condition['type'] === 'NOT') {
                        $whereParts[] = $condition['type'];
                        continue;
                }
              }
                
              if (isset($condition['columnName']) && isset($condition['condition']) && isset($condition['columnValue'])){
               
               
                $value =  $condition['columnValue'];
        
                try {
                    $value = intval($condition['columnValue']);
                  if ($value == 0 && $condition['columnValue'] != '0') {
                        $value = "'" . $condition['columnValue'] . "'";
                  }
                } catch (TypeError $e) {
                    $value = "'" . $condition['columnValue'] . "'";
                }
         
               $wherePart = $condition['columnName'] . " " . $condition['condition'] . " " . $value;
               $whereParts[] = $wherePart;
             }
        
         }

         $query .= " WHERE ". implode(" ", $whereParts);  

        }

        return $query;
   }else{
       return "error";
   }
}


function getRemoveValueCountJSON($json) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) || !isset($tableInfo['valueCount']) || !isset($tableInfo['conditions'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];
    $valueCount = $tableInfo['valueCount'];

    $conditions = isset($tableInfo['conditions']) ? $tableInfo['conditions'] : null;

    if ($tableName != null && $columnName != null && $valueCount != null) {

        $tableName = replace_item($tableName);

    
        $query = "UPDATE $tableName  SET $columnName = $columnName - $valueCount";
    
        if ($conditions !== null) {

            $whereParts = [];

            foreach ($conditions as $condition) {

                if (isset($condition['type'])){
                    if ($condition['type'] === 'AND' || $condition['type'] === 'OR' || $condition['type'] === 'NOT') {
                        $whereParts[] = $condition['type'];
                        continue;
                }
              }
                
              if (isset($condition['columnName']) && isset($condition['condition']) && isset($condition['columnValue'])){
               
               
                $value =  $condition['columnValue'];
        
                try {
                    $value = intval($condition['columnValue']);
                  if ($value == 0 && $condition['columnValue'] != '0') {
                        $value = "'" . $condition['columnValue'] . "'";
                  }
                } catch (TypeError $e) {
                    $value = "'" . $condition['columnValue'] . "'";
                }
         
               $wherePart = $condition['columnName'] . " " . $condition['condition'] . " " . $value;
               $whereParts[] = $wherePart;
             }
        
         }

         $query .= " WHERE ". implode(" ", $whereParts);  

        }

        return $query;
   }else{
       return "error";
   }
}


function getCountRowFromJSON($json) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) || !isset($tableInfo['type'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];
    $type = $tableInfo['type'];

    $conditions = isset($tableInfo['conditions']) ? $tableInfo['conditions'] : null;

    if ($tableName != null && $columnName != null && $type != null) {

        $tableName = replace_item($tableName);

        $aggregationFunctions = ["COUNT", "SUM", "AVG"];

        if (!in_array(strtoupper($type), $aggregationFunctions)) {
            return "error";
        }
    
        $query = "SELECT $type($columnName) FROM $tableName";
    
        if ($conditions !== null) {

            $whereParts = [];

            foreach ($conditions as $condition) {

                if (isset($condition['type'])){
                    if ($condition['type'] === 'AND' || $condition['type'] === 'OR' || $condition['type'] === 'NOT') {
                        $whereParts[] = $condition['type'];
                        continue;
                }
              }
                
              if (isset($condition['columnName']) && isset($condition['condition']) && isset($condition['columnValue'])){
               
               
                $value =  $condition['columnValue'];
        
                try {
                    $value = intval($condition['columnValue']);
                  if ($value == 0 && $condition['columnValue'] != '0') {
                        $value = "'" . $condition['columnValue'] . "'";
                  }
                } catch (TypeError $e) {
                    $value = "'" . $condition['columnValue'] . "'";
                }
         
               $wherePart = $condition['columnName'] . " " . $condition['condition'] . " " . $value;
               $whereParts[] = $wherePart;
             }
        
         }

         $query .= " WHERE ". implode(" ", $whereParts);  

        }

        return $query;
   }else{
       return "error";
   }
}


 function getInFilterRows($json){

   $tableInfo = json_decode($json, true);
    
   if (!isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) ||  !isset($tableInfo['values'])) {
            return "error"; // Invalid JSON 
        }
    
        $tableName = $tableInfo['tableName'];
        $columnName = $tableInfo['columnName'];
        $values = implode("','", $tableInfo['values']); 

    
        $query = "SELECT * FROM $tableName WHERE $columnName IN ('$values');";
    
        return $query;
}


function getNotInFilterRows($json){
    
    $tableInfo = json_decode($json, true);
     
    if (!isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) ||  !isset($tableInfo['values'])) {
             return "error"; // Invalid JSON 
         }
     
         $tableName = $tableInfo['tableName'];
         $columnName = $tableInfo['columnName'];
         $values = implode("','", $tableInfo['values']); 
 
     
         $query = "SELECT * FROM $tableName WHERE $columnName NOT IN ('$values');";
     
         return $query;
 }




 

function getConditionRows($json) {
 
    $tableInfo = json_decode($json, true);

    if (!isset($tableInfo['tableName']) || !isset($tableInfo['conditions'])) {
        return "error"; // Invalid JSON 
    }

 $query = "SELECT * FROM " . $tableInfo['tableName'];
 
 // Conditions

$conditions = isset($tableInfo['conditions']) ? $tableInfo['conditions'] : null;
   
 if ( $conditions!=null && !empty($conditions)) {

   $whereParts1 = [];

    foreach ($conditions as $condition) {

      if (isset($condition['type'])){
      $whereParts1[] = $condition['type'];
      }
        
      if (isset($condition['columnName']) && isset($condition['condition']) && isset($condition['columnValue'])){
       
        $value =  $condition['columnValue'];

        try {
            $value = intval($condition['columnValue']);
          if ($value == 0 && $condition['columnValue'] != '0') {
                $value = "'" . $condition['columnValue'] . "'";
          }
        } catch (TypeError $e) {
            $value = "'" . $condition['columnValue'] . "'";
        }
 
      $wherePart = $condition['columnName'] . " " . $condition['condition'] . " " . $value;
       $whereParts1[] = $wherePart;
     }
    }
   $query .= " WHERE ". implode(" ", $whereParts1);
 }
 
// OrderBy
 
$orderBy = isset($tableInfo['orderBy']) ? $tableInfo['orderBy'] : null;


if ($orderBy!=null && !empty($orderBy)){

     $whereParts2 = [];
    
     foreach ($orderBy as $order) {

      if (isset($order['columnName'])){
       
        $columnName =  $order['columnName'];
        $descending = isset($order['descending']) ? $order['descending'] : false;

        $wherePart = "";

        if ($descending == true) {
           $wherePart = $columnName . " DESC";
        }else {
            $wherePart = $columnName . " ASC";
        }
       $whereParts2[] = $wherePart;
     }
 }
 
 $query .= " ORDER BY ". implode(", ", $whereParts2);

}

 // Limit

$limit = isset($tableInfo['limit']) ? $tableInfo['limit'] : null;

if ($limit!=null && !empty($limit)){
	
	$min = isset($limit['min']) ? $limit['min'] :null;
	$max = isset($limit['max']) ? $limit['max'] :null;
	
	if($min!=null && $max != null){
		
	$query .= " LIMIT ".$min.",".$max;
		
	}
	
}


 
return $query;
}



function getLikeRowFromJSON($json) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columnName']) || !isset($tableInfo['columnValue'])) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];
    $columnName = $tableInfo['columnName'];
    $columnValue = $tableInfo['columnValue'];

   $conditions = isset($tableInfo['conditions']) ? $tableInfo['conditions'] : null;

   $orderBy = isset($tableInfo['orderBy']) ? $tableInfo['orderBy'] : null;
       

    if ($tableName != null && $columnName != null && $columnValue != null) {

         $tableName = replace_item($tableName);

        $query = "SELECT * FROM $tableName WHERE $columnName LIKE '$columnValue'";


        if ( $conditions!=null && !empty($conditions)) {
       
            $whereParts1 = [];
       
           foreach ($conditions as $condition) {
       
             if (isset($condition['type'])){
             $whereParts1[] = $condition['type'];
             }
               
             if (isset($condition['columnName']) && isset($condition['condition']) && isset($condition['columnValue'])){
              
               $value =  $condition['columnValue'];
       
               try {
                   $value = intval($condition['columnValue']);
                 if ($value == 0 && $condition['columnValue'] != '0') {
                       $value = "'" . $condition['columnValue'] . "'";
                 }
               } catch (TypeError $e) {
                   $value = "'" . $condition['columnValue'] . "'";
               }
        
             $wherePart = $condition['columnName'] . " " . $condition['condition'] . " " . $value;
              $whereParts1[] = $wherePart;
            }
           }
          $query .= " AND ". implode(" ", $whereParts1);
        }
        
       
       if ($orderBy!=null && !empty($orderBy)){
       
            $whereParts2 = [];
           
            foreach ($orderBy as $order) {
       
             if (isset($order['columnName'])){
              
               $columnName =  $order['columnName'];
               $descending = isset($order['descending']) ? $order['descending'] : false;
       
               $wherePart = "";
       
               if ($descending == true) {
                  $wherePart = $columnName . " DESC";
               }else {
                   $wherePart = $columnName . " ASC";
               }
              $whereParts2[] = $wherePart;
            }
        }
        
        $query .= " ORDER BY ". implode(", ", $whereParts2);
       
       }

        return $query;
    }else{
        return "error";
    }

  
}

function getAllRowFromJSON($json) {

    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columns'])) {
        return "error"; //Invalid JSON data
    }

 
    $tableName = $tableInfo['tableName'];

    $tableName = replace_item($tableName);

    $columns =  $tableInfo['columns'];


    $filter_key = isset($tableInfo['filter_key']) ? $tableInfo['filter_key'] : null;
    $filter_value = isset($tableInfo['filter_value']) ? $tableInfo['filter_value'] : null;

    $like_key = isset($tableInfo['like_key']) ? $tableInfo['like_key'] : null;
    $like_value = isset($tableInfo['like_value']) ? $tableInfo['like_value'] : null;

    $orderBy = isset($tableInfo['orderBy']) ? $tableInfo['orderBy'] : null;
    $descending = isset($tableInfo['descending']) ? $tableInfo['descending'] : false; 

    $query = "SELECT $columns FROM $tableName";

    if ($filter_key != null && $filter_value != null) {
        $query  .= " WHERE ".$filter_key." = '".$filter_value."'";
    }

    if ($like_key != null && $like_value != null) {
        $query  .= " WHERE ".$like_key." LIKE '".$like_value."'";
    }
    
    if ($orderBy != null) {
       
        $query  .=" ORDER BY ".$orderBy;
 
       if ($descending == true) {
         $query  .= " DESC";
       }else {
          $query  .= " ASC";
       }
         
     }

      // Limit

    $limit = isset($tableInfo['limit']) ? $tableInfo['limit'] : null;

    if ($limit!=null && !empty($limit)){
	
	$min = isset($limit['min']) ? $limit['min'] :null;
	$max = isset($limit['max']) ? $limit['max'] :null;
	
	if($min!=null && $max != null){
		
	$query .= " LIMIT ".$min.",".$max;
		
	}
	
}

    return $query;
}

function insertOrUpdateRowFromJSON($json){
    $tableInfo = json_decode($json, true);
    if ($tableInfo === null || !isset($tableInfo['tableName']) || !isset($tableInfo['columns']) || !isset($tableInfo['values']) ) {
        return "error"; //Invalid JSON data
    }

    $tableName = $tableInfo['tableName'];

    $tableName = replace_item($tableName); 

    unset($tableInfo['tableName']);
    
    $columns = implode(', ', array_map(function($column) {
        return "`$column`";
    }, $tableInfo['columns']));
   
    $values = "'" . implode("', '", $tableInfo['values']) . "'";
    
    $insertQuery = "INSERT INTO $tableName ($columns) VALUES ($values)";

    $update = isset($tableInfo['update']) ? $tableInfo['update'] : false;

    if($update == true){
     
    $updateQuery = " ON DUPLICATE KEY UPDATE ";

    foreach ($tableInfo['columns'] as $index => $column) {
        if ($index !== 0) {  
            $updateQuery .= "$column = '" . $tableInfo['values'][$index] . "', ";
        }
    }

    $updateQuery = rtrim($updateQuery, ", ");

    return $insertQuery . $updateQuery;

    }

   return $insertQuery;

}


function replace_item(string $var): string
{
    $unsupported_characters = [' '];

    foreach ($unsupported_characters as $character) {
        $var = str_replace($character, '_', $var);
    }
    return $var;
}


function replace_extra(string $var): string
{
    $unsupported_characters = ['  '];

    foreach ($unsupported_characters as $character) {
        $var = str_replace($character, ' ', $var);
    }
    return $var;
}


?>
