<?php

/*
---- DeepHost : MySQL Database PHP Server ---
---- Last Update : 18-06-2024 10:27AM ----
*/

$version = "1.8";

include_once("config.php");
include_once("function.php");

header('Content-Type: application/json');  

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if(isset($_POST['api'])  && $_POST['api'] == $apiKey) {

        if(isset($_POST['version'])){
            if($version != $_POST['version']){
              echo json_encode(array("failed" => "Update your 'server.php' and 'function.php' files."));
              exit;
            }else {
   if ($apiKey == '') {
            echo json_encode(array("failed" => "Setup your strong 'apiKey' in config.php files."));
            exit;
        }else if ($serverName == '') {
            echo json_encode(array("failed" => "Setup your 'serverName' in config.php file"));
            exit;
        }elseif ($username == '') {
            echo json_encode(array("failed" => "Setup your 'username' in config.php file"));
            exit;
        }elseif ($database == '') {
            echo json_encode(array("failed" => "Setup your 'database' in config.php file"));
            exit;
        }else {
           
            $conn = new mysqli($serverName, $username, $password, $database);
     
            if ($conn->connect_error) {
                echo json_encode(array("failed" => "Connection failed"));
                exit;
            }

            $conn -> set_charset($charset);
    
            if(isset($_POST['json'])){
    
                if(isset($_POST['type'])){
    
                    $type = $_POST['type'];
    
                    if ($type == 'CreateTable') {
                        
                        $json = $_POST['json'];
                        $query = createTableFromJSON($json, $charset);
                       
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                        }else {
    
                            try {
                                      if ($conn->query($query) === TRUE) {
                            echo json_encode(array("response" => "Table is Created"));
                        }else{
                            echo json_encode(array("failed" => "Request Error" , "json" => $json, "query" => $query));
                        }
                        } catch (mysqli_sql_exception $e) {
                                           
                            echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                              
                  }           
             }
            
            } else  if ($type == 'AddColumn') {
                        
                $json = $_POST['json'];
                $query = addColumnFromJSON($json);
               
                if ($query == 'error') {
                    echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                }else {
    
                    try {
                              if ($conn->query($query) === TRUE) {
                    echo json_encode(array("response" => "Column is added"));
                }else{
                    echo json_encode(array("failed" => "Request Error" , "json" => $json, "query" => $query));
                }
                } catch (mysqli_sql_exception $e) {
                                   
                    echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                }        
          } 
          } else  if ($type == 'RemoveColumn') {
                        
            $json = $_POST['json'];
            $query = removeColumnFromJSON($json);
           
            if ($query == 'error') {
                echo json_encode(array("failed" => "Invalid JSON data" , "json" => $json));
            }else {
    
                try {
                          if ($conn->query($query) === TRUE) {
                echo json_encode(array("response" => "Column is removed"));
            }else{
                echo json_encode(array("failed" => "Request Error" , "json" => $json, "query" => $query));
            }
            } catch (mysqli_sql_exception $e) {
                               
                echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
            }        
      } 
      }  else if($type == 'CreateRows'){
                      
                        $json = $_POST['json'];
                        $query = insertOrUpdateRowFromJSON($json);
					  
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data" , "json" => $json));
                        }else {
                            try {
                                if ($conn->query($query) === TRUE) {
                                    echo json_encode(["response" => "Row is Added"]);
                                } else {
                                    echo json_encode(["failed" => "Request Error: " . $conn->error]);
                                }
                            } catch (mysqli_sql_exception $e) {
                                if ($e->getCode() == 1062) {
                                     echo json_encode(["failed" => "Row is already exist" , "json" => $json, "query" => $query]);
                                } else {
                                    echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                                }
                            }
    
                     }
    
                    } else if($type == 'AddValueCount'){
                      
                        $json = $_POST['json'];
                        $query = getAddValueCountJSON($json);
                      
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data" , "json" => $json));
                        }else {
                            try {
                                if ($conn->query($query) === TRUE) {
                                    echo json_encode(["response" => "Value Count is Added"]);
                                } else {
                                    echo json_encode(["failed" => "Request Error: " . $conn->error]);
                                }
                            } catch (mysqli_sql_exception $e) {
                            
                              echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                            }
    
                     }
    
                    } else if($type == 'RemoveValueCount'){
                      
                        $json = $_POST['json'];
                        $query = getRemoveValueCountJSON($json);
                      
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data" , "json" => $json));
                        }else {
                            try {
                                if ($conn->query($query) === TRUE) {
                                    echo json_encode(["response" => "Value Count is Removed"]);
                                } else {
                                    echo json_encode(["failed" => "Request Error: " . $conn->error]);
                                }
                            } catch (mysqli_sql_exception $e) {
                            
                              echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                            }
    
                     }
    
                    }else if($type == 'CreateMultipleRows'){
    
                        $json = $_POST['json'];
    
                        $data = json_decode($json, true);
                        
                        if (is_null($data) || !isset($data['tableName']) || !isset($data['columns']) || !isset($data['values'])) {
                            echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                            exit;
                        }
                        
                        $tableName = $data['tableName'];
                        $columns = $data['columns'];
                        $values = $data['values'];
                        $update = $data['update'];
    
                        $rowCount = count($values[0]);
    
                        foreach ($values as $valueSet) {
                            if (count($valueSet) !== $rowCount) {
                                echo json_encode(array("failed" => "All Values list size is not Equal", "json" => $json, "query" => $query));
                                exit;
                            }
                        }
                        
                        
                        
                          $count = 0;
    
                          
                          for ($i = 0; $i < $rowCount; $i++) {
                            $valueSet = [];
                            foreach ($values as $valueArray) {
                              $valueSet[] = $valueArray[$i];
                          }
                           $jsonRow = json_encode([
                               "tableName" => $tableName,
                               "columns" => $columns,
                               "values" => $valueSet,
                               "update" => $update
                              ]);
                              
                            $query = insertOrUpdateRowFromJSON($jsonRow);
                        
                             if ($query != "error"){
                               if ($conn->query($query) === TRUE) {
                                 $count++;
                               }
                             }
                          }
    
                      if ($count > 0) {
                        echo json_encode(array("response" => "Rows is Added ".$count));
                      }else{
                        echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                      }
    
                    } else if($type == 'DeleteRows'){
                      
                        $json = $_POST['json'];
                        $query = deleteRowFromJSON($json);
                      
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                        }else {
    
                            try {
                                if ($conn->query($query) === TRUE) {
                            echo json_encode(array("response" => "Row is Deleted"));
                        }else{
                            echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                        }
                      } catch (mysqli_sql_exception $e) {
                        echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
    
                       }
                      
                     }
    
                    }else if($type == 'GetRows'){
                      
                        $json = $_POST['json'];
                        $query = getRowFromJSON($json);
    
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                        }else {
    
                            try {
    
                                   $result = $conn->query($query);
                                   
                                   if ($result->num_rows == 1) {
    
                                $row = $result->fetch_assoc();
    
                                echo json_encode(array("response" => $row));    
    
                            } else{
                            echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                        }
                            } catch (mysqli_sql_exception $e) {
                                           
                                echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                              }
                            
                         }
    
                    }else if($type == 'CountRows'){
                      
                        $json = $_POST['json'];
                        $query = getCountRowFromJSON($json);
    
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                        }else {
    
                            try {
    
                              $result = $conn->query($query);
                                   
                         if ($result->num_rows == 1) {
    
                           $row = $result->fetch_assoc();

                            $columnName = key($row);

                          list($aggregationFunction, $actualColumnName) = sscanf($columnName, '%[^()] (%[^()]');

                                 $response = [
                                     'type' => strtoupper($aggregationFunction),
                                     'columnName' => $actualColumnName,
                                     'result' => $row[$columnName]
                                 ];

                                 echo json_encode(array("response" => $response));    
    
                           } else{
                            echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                        }
                            } catch (mysqli_sql_exception $e) {
                                           
                                echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                              
                  }
      
              }
    
             } else if($type == 'GetConditionRows'){
                      
                        $json = $_POST['json'];
                       $query = getConditionRows($json);
           
                     if ($query == 'error') {
                        echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                    }else   {
    
                        try {
    
                         $result = $conn->query($query);
    
                        if ($result -> num_rows > 0) {
    
                            $data = array();
    
                            while ($row = $result->fetch_assoc()) {
                                $data[] = $row;
                            }
    
                            echo json_encode(array("response" => $data));    
    
                        } else{
                        echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                    }
                        } catch (mysqli_sql_exception $e) {
                            echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                          
              }                
             }
                   
                 }else if($type == 'GetInFilterRows') {
                      
                    $json = $_POST['json'];
                    $query = getInFilterRows($json);
    
                 if ($query == 'error') {
                    echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                }else   {
    
                    try {
    
                     $result = $conn->query($query);
    
                    if ($result -> num_rows > 0) {
    
                        $data = array();
    
                        while ($row = $result->fetch_assoc()) {
                            $data[] = $row;
                        }
    
                        echo json_encode(array("response" => $data));    
    
                    } else{
                    echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                }
                    } catch (mysqli_sql_exception $e) {
                                   
                        echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                                   
          }
        }
             } else if($type == 'GetNotInFilterRows') {
                      
        $json = $_POST['json'];
        $query = getNotInFilterRows($json);
    
     if ($query == 'error') {
        echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
    }else   {
    
        try {
    
         $result = $conn->query($query);
    
        if ($result -> num_rows > 0) {
    
            $data = array();
    
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
    
            echo json_encode(array("response" => $data));    
    
        } else{
        echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
    }
        } catch (mysqli_sql_exception $e) {
                       
            echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                                     
    }
    }
    } else if($type == 'LikeRows'){
                      
                        $json = $_POST['json'];
                        $query = getLikeRowFromJSON($json);
    
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data" , "json" => $json));
                        }else {
    
                            try {
    
                                $result = $conn->query($query);
                           
                               if ($result -> num_rows > 0) {
                           
                                   $data = array();
                           
                                   while ($row = $result->fetch_assoc()) {
                                       $data[] = $row;
                                   }
                           
                                   echo json_encode(array("response" => $data));    
                           
                               } else{
                               echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                           }
                               } catch (mysqli_sql_exception $e) {
                                              
                                echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                                     
                           }
                             
                     }
    
                    }else if($type == 'GetAllRows'){
                      
                        $json = $_POST['json'];
                        $query = getAllRowFromJSON($json);
    
                        if ($query == 'error') {
                            echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
                        }else   {
    
                            try {
    
                                    $result = $conn->query($query);
    
                            if ($result -> num_rows > 0) {
    
                                $data = array();
    
                                while ($row = $result->fetch_assoc()) {
                                    $data[] = $row;
                                }
    
                                echo json_encode(array("response" => $data));    
    
                            } else{
                            echo json_encode(array("failed" => "Request Error", "json" => $json, "query" => $query));
                        }
                            } catch (mysqli_sql_exception $e) {
                                           
                                echo json_encode(array("failed" =>  $e->getMessage(), "json" => $json, "query" => $query));
                           
                              
                  }
    
                        
                     }
                       
                    }else {
                         
                     echo json_encode(array("failed" => "Invalid Type"));
                        
                    }
    
                }else {
                    echo json_encode(array("failed" => "Invalid Type"));
                }
    
            }else { 
                echo json_encode(array("failed" => "Invalid JSON data", "json" => $json));
            }
           
            $conn->close();
        }

            }
        }else {
            echo json_encode(array("failed" => "Update your Server.php and Function.php file"));
            exit;
        }
    
    }else {
        echo json_encode(array("failed" => "Invalid API key"));
    }

    
} else { 
    echo json_encode(array("failed" => "Invalid Request"));
}

?>